<?php
namespace TYPO3\CMS\Form\Domain\Model\Attribute;

/***************************************************************
 *  Copyright notice
 *
 *  (c) 2008-2013 Patrick Broens (patrick@patrickbroens.nl)
 *  All rights reserved
 *
 *  This script is part of the TYPO3 project. The TYPO3 project is
 *  free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  The GNU General Public License can be found at
 *  http://www.gnu.org/copyleft/gpl.html.
 *
 *  This script is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  This copyright notice MUST APPEAR in all copies of the script!
 ***************************************************************/

/**
 * Attribute 'title'
 *
 * @author Patrick Broens <patrick@patrickbroens.nl>
 */
class TitleAttribute extends \TYPO3\CMS\Form\Domain\Model\Attribute\AbstractAttribute {

	/**
	 * Gets the attribute 'title'.
	 * Used with all elements
	 * Case Sensitive
	 *
	 * This attribute offers advisory information about the element for which it is set.
	 * Unlike the TITLE element, which provides information about an entire
	 * document and may only appear once, the title attribute may annotate any
	 * number of elements. Please consult an element's definition to verify that
	 * it supports this attribute.
	 *
	 * Values of the title attribute may be rendered by user agents in a variety
	 * of ways. For instance, visual browsers frequently display the title as a
	 * "tool tip" (a short message that appears when the pointing device pauses
	 * over an object). Audio user agents may speak the title information in a
	 * similar context.
	 *
	 * @return string Attribute value
	 */
	public function getValue() {
		$attribute = (string) $this->value;
		return $attribute;
	}

}

?>