<?php

  // Initialize session data
  session_start();

  // IE 6 Fix
  header("Cache-control: private");

  // Lade die funktionen fr den Zugriff auf die Datenbank
  require_once('baseFunction.inc.php');

  // Lade den oberen Teil der HTML Seite
  include('header.inc.php');

  // Bei einem Login prfe Eingaben gegen die Datenbank wenn korrekt aktiviere die Session
  if ($_POST['action'] == "login")  {
    $login = check_login($_POST['username'], $_POST['password']);
    if ($login)  {
      $_SESSION['user_id'] = $login['user_id'];
      $_SESSION['username'] = $login['username'];
      $_SESSION['language'] = $login['language'];

      // Lade das Sprachenregister
      require ('lang/register.inc.php');
      require "lang/".$register['file'][$_SESSION['language']];
      $_SESSION['lang'] = $lang;
      $_GET['action'] = "show_directory_entries";
    }
  }

  // Prfe ob die Session aktiv ist
  if (!empty($_SESSION['user_id']))  {

    // Lade die Navigationszeile
    include('navigation.inc.php');

    // verteile ja nach Aufruf in die entsprechenden Funktionen
    switch ($_GET['action'])  {

    // Dialog zur Eingabe neuer Nummern
    case "add_directory_entries":
      include('add_entry.inc.php');
    break;

    // neuen Eintrag in Datenbank schreiben oder vorhandenen aktualisieren
    case "insert_update_entry":
      insert_update_entry($_GET['entry_id'], $_POST['name'], $_POST['lastname']);
    break;

    // Eintrag aus Datenbank lschen
    case "del_directory_entries":
      del_directory_entries($_GET['entry_id']);
    break;

    // Dialog zum ndern von Eintrgen
    case "mod_directory_entries":
      mod_directory_entries($_GET['entry_id']);
    break;

    // zeige vorhanden Eintrge
    case "show_directory_entries":
      show_directory_entries();
    break;
//******************************************************************************************************

    // Dialog zum Anzeigen der Rufnummern eines Eintrages
    case "show_directory_entry_numbers":
      show_directory_entry_numbers($_GET['entry_id']);
    break;

    // Dialog zum hinzufgen von Rufnummern
    case "del_directory_entry_number":
      del_directory_entry_number($_GET['number_id'], $_GET['entry_id']);
    break;

    // Dialog zum hinzufgen von Rufnummern
    case "mod_directory_entry_numbers":
      mod_directory_entry_numbers($_GET['number_id'], $_GET['entry_id']);
    break;

    // Dialog zum hinzufgen von Rufnummern
    case "add_directory_entry_numbers":
      add_directory_entry_numbers($_GET['entry_id']);
    break;

    // hinzufgen und ndern von rufnummern
    case "insert_update_entry_number":
      insert_update_entry_number($_GET['number_id'], $_POST['type_id'], $_POST['entry_id'], $_POST['number']);
    break;


    // zeige Telefone des Benutzers
    case "show_user_phones":
      show_user_phones();
    break;

    // Dialog zur Eingabe neuer Telefone
    case "add_user_phones":
      include('add_phone.inc.php');
    break;

    // neues Telefon in Datenbank speichern
    case "insert_user_phones":
      insert_user_phones($_POST['name']);
    break;

    // Lsche Telefon aus Datenbank
    case "del_user_phones":
      del_user_phones($_GET['phone_id']);
    break;

    // zeige dialog zum ndern von Username/Password
    case "show_my_settings":
     mod_directory_user($_SESSION['user_id'], $_GET['action']);
    break;

    // genderte Benutzerdaten in Datenbank speichern
    case "update_my_settings":
     insert_update_user($_SESSION['user_id'], $_POST['username'], $_POST['password'], $_POST['lang']);
    break;

    /* Zugriff nur fr User mit ID 1
    zeige alle Benutzer des Directories  */  
    case "show_directory_user":
      if ($_SESSION['user_id'] == "1")  {
        show_directory_user();
      } else {
        echo "Du bist nicht autorisiert";
      }
    break;

    // zeige Dialog zum Anlegen neuer Benutzer
    case "add_directory_user":
      if ($_SESSION['user_id'] == "1")  {
        unset($user_id, $username);                                       //register globals On Patch
        include('add_user.inc.php');
      } else {
        echo "Du bist nicht autorisiert";
      }
    break;

    // ndern oder hinzufgen von Nutzerdaten in Datenbank
    case "insert_update_user":
      if ($_SESSION['user_id'] == "1")  {
        insert_update_user($_GET['user_id'], $_POST['username'], $_POST['password'], $_POST['lang']);
      } else {
        echo "Du bist nicht autorisiert";
      }
    break;

    // lsche Benutzer
    case "del_directory_user":
      if ($_SESSION['user_id'] == "1")  {
        del_directory_user($_GET['user_id']);
      } else {
        echo "Du bist nicht autorisiert";
      }
    break;

    // zeige Dialog zum ndern von Nutzerdaten
    case "mod_directory_user":
      if ($_SESSION['user_id'] == "1")  {
        mod_directory_user($_GET['user_id'], $_GET['action']);
      } else {
        echo "Du bist nicht autorisiert";
      }
    break;

    // Zeige die Nummerntypen des Directory
    case "show_number_types":
      if ($_SESSION['user_id'] == "1")  {
        show_number_types();
      } else {
        echo "Du bist nicht autorisiert";
      }
    break;

    // lsche Nummerntyp
    case "del_number_types":
      if ($_SESSION['user_id'] == "1")  {
        del_number_types($_GET['type_id']);
      } else {
        echo "Du bist nicht autorisiert";
      }
    break;

    // zeige Dialog zum Anlegen neuer Nummerntypen
    case "add_number_types":
      if ($_SESSION['user_id'] == "1")  {
        include('add_type.inc.php');
      } else {
        echo "Du bist nicht autorisiert";
      }
    break;

    // ndern oder hinzufgen von Nummerntypen in Datenbank
    case "insert_update_types":
      if ($_SESSION['user_id'] == "1")  {
        insert_update_types($_GET['type_id'], $_POST['type']);
      } else {
        echo "Du bist nicht autorisiert";
      }
    break;

    // zeige Dialog zum ndern von Nummerntypen
    case "mod_number_types":
      if ($_SESSION['user_id'] == "1")  {
        mod_number_types($_GET['type_id']);
      } else {
        echo "Du bist nicht autorisiert";
      }
    break;


    // wenn keine action oder garbage im GET dann zeige das directory
    default:
      show_directory_entries();
    }

  // wenn Session nicht aktiv dann zeige Login Seite
  } else {
    include 'login_mask.inc.php';
  }

  // Lade den unteren Teil der HTMl Seite
  include('footer.inc.php');


















function insert_user_phones($name)
{
  $query  = "insert into directory_phones (user_id, name) ";
  $query .= "values (".$_SESSION['user_id'].", '$name')";
  connect_db();  // connect to the DB
  safe_query($query);
  show_user_phones();
}


function del_user_phones($phone_id)
{
  $query = "delete from directory_phones where phone_id = '$phone_id' AND user_id = " .$_SESSION['user_id'];
  connect_db();  // connect to the DB
  safe_query($query);
  show_user_phones();
}


function show_user_phones()
{
  connect_db();  // connect to the DB
  $query = "select * from directory_phones where user_id = ".$_SESSION['user_id'];
  $result = safe_query($query);
  if ($result)
  {
    echo "<table border=\"1\">\n";
    echo "<tr>\n";
    echo "\t<td><b>".$_SESSION['lang']['phonename']."</b></td>\n";
    echo "</tr>\n";

    while ($row = mysql_fetch_array($result, MYSQL_ASSOC))
    {
      echo "<tr>\n";
      echo "\t<td>".$row['name']."</td>\n";
      echo "\t<td><a href=\"index.php?action=del_user_phones&phone_id=".$row['phone_id']."\"><img src=\"images/del_entry.png\" border=\"0\" alt=\"".$_SESSION['lang']['delete']."\" title=\"".$_SESSION['lang']['delete']."\"></a></td>\n";
      echo "</tr>\n";
    }
    echo "</table>\n";
    echo "<br>\n";
    echo "<a href=\"index.php?action=add_user_phones\"><img src=\"images/add_entry.png\" border=\"0\" >".$_SESSION['lang']['addphone']."</a>\n";
    mysql_free_result($result);
  }
}


function mod_directory_user($user_id, $call)
{
  $query = "select * from directory_user where user_id  = '$user_id'";
  connect_db();  // connect to the DB
  $result = safe_query($query);

  if ($result)
  {
    while ($row = mysql_fetch_array($result, MYSQL_ASSOC))
    {
      $username=$row['username'];
      $language=$row['language'];
    }
  }
  if ($call == "mod_directory_user") include('add_user.inc.php');
  if ($call == "show_my_settings") include('my_settings.inc.php');
  mysql_free_result($result);
}


function del_directory_user($user_id)
{
  $query1  = "delete from directory_user where user_id = '$user_id'";

  $query2  = "delete from directory_phones where user_id = '$user_id'";

  $query3  = "delete from directory_numbers ";
  $query3 .= "using directory_numbers, directory_entries ";
  $query3 .= "where directory_numbers.entry_id = directory_entries.entry_id ";
  $query3 .= "and directory_entries.user_id = '$user_id'";

  $query4  = "delete from directory_entries where user_id = '$user_id'";

  connect_db();  // connect to the DB
  safe_query($query1);
  safe_query($query2);
  safe_query($query3);
  safe_query($query4);
  show_directory_user();
}


function insert_update_user($user_id, $username, $password, $language)
{

  // Benutzer neu anlegen
  if (empty($user_id))  {
  $query  = "insert into directory_user (username, password) values ";
  $query .= "('$username', password('$password'))";
  }

  // bestehenden Benutzer Passwort und Sprache ndern
  if (!empty($user_id) && !empty($password))  {
  $query  = "update directory_user set ";
  $query .= "username='$username', password=password('$password'), language='$language' ";
  $query .= "where user_id='$user_id'";
  }

  // bestehenden Benutzer Sprache ndern
  if (!empty($user_id) && empty($password))  {
  $query  = "update directory_user set ";
  $query .= "username='$username', language='$language' ";
  $query .= "where user_id='$user_id'";
  }

  connect_db();  // connect to the DB
  safe_query($query);
  if ($_SESSION['user_id'] == "1")  {
    show_directory_user();
  } else {
    show_directory_entries();
  }
}


function show_directory_user()
{
  $query = "select * from directory_user";
  connect_db();  // connect to the DB
  $result = safe_query($query);
  if ($result)
  {
    echo "<table border=\"1\">\n";
    echo "<tr>\n";
    echo "\t<td><b>".$_SESSION['lang']['userid']."</b></td>\n";
    echo "\t<td><b>".$_SESSION['lang']['username']."</b></td>\n";
    echo "\t<td><b>".$_SESSION['lang']['pwdhash']."</b></td>\n";
    echo "</tr>\n";

    while ($row = mysql_fetch_array($result, MYSQL_ASSOC))
    {
      echo "<tr>\n";
      echo "\t<td>".$row['user_id']."</td>\n";
      echo "\t<td>".$row['username']."</td>\n";
      echo "\t<td>".$row['password']."</td>\n";

      if ($row['user_id'] != "1") {
        echo "\t<td><a href=\"index.php?action=del_directory_user&user_id=".$row['user_id']."\"><img src=\"images/del_entry.png\" border=\"0\" alt=\"".$_SESSION['lang']['delete']."\" title=\"".$_SESSION['lang']['delete']."\"></a></td>\n";
        echo "\t<td><a href=\"index.php?action=mod_directory_user&user_id=".$row['user_id']."\"><img src=\"images/mod_user.png\" border=\"0\" alt=\"".$_SESSION['lang']['edit']."\" title=\"".$_SESSION['lang']['edit']."\"></a></td>\n";
      } else {
        echo "\t<td></td>\n";
        echo "\t<td><a href=\"index.php?action=mod_directory_user&user_id=".$row['user_id']."\"><img src=\"images/mod_user.png\" border=\"0\" alt=\"".$_SESSION['lang']['edit']."\" title=\"".$_SESSION['lang']['edit']."\"></a></td>\n";
      }
      
      echo "</tr>\n";
    }
    echo "</table>\n";
    echo "<br>\n";
    echo "<a href=\"index.php?action=add_directory_user\"><img src=\"images/add_user.png\" border=\"0\">".$_SESSION['lang']['adduser']."</a>\n";
  }
  mysql_free_result($result);
}


function insert_update_entry($entry_id, $name, $lastname)
{

  if (empty($entry_id))  {
  $query  = "insert into directory_entries (user_id, name, lastname) ";
  $query .= "values (".$_SESSION['user_id'].", '$name', '$lastname')";
  } else {
  $query  = "update directory_entries set ";
  $query .= "name='$name', lastname='$lastname' ";
  $query .= "where entry_id='$entry_id' AND user_id = " .$_SESSION['user_id'];
  }

  connect_db();  // connect to the DB
  safe_query($query);
  show_directory_entries();
}


function mod_directory_entries($entry_id)
{
  $query = "select * from directory_entries where entry_id  = '$entry_id' AND user_id = " .$_SESSION['user_id'];
  connect_db();  // connect to the DB
  $result = safe_query($query);

  if ($result)
  {
    while ($row = mysql_fetch_array($result, MYSQL_ASSOC))
    {
      $entry_id=$row['entry_id'];
      $name=$row['name'];
      $lastname=$row['lastname'];
    }
  }
  if (mysql_num_rows($result) > 0)  {
    include('add_entry.inc.php');
  } else {
    show_directory_entries();
  }
  mysql_free_result($result);
}



function del_directory_entries($entry_id)
{
  $query  = "delete from directory_numbers ";
  $query .= "using directory_numbers, directory_entries ";
  $query .= "where directory_numbers.entry_id = directory_entries.entry_id ";
  $query .= "and directory_entries.entry_id = '$entry_id' ";
  $query .= "and directory_entries.user_id = ".$_SESSION['user_id'];

  connect_db();  // connect to the DB
  safe_query($query);

  $query  = "delete from directory_entries ";
  $query .= "where directory_entries.entry_id = '$entry_id' ";
  $query .= "and directory_entries.user_id = ".$_SESSION['user_id'];

  connect_db();  // connect to the DB
  safe_query($query);

  show_directory_entries();
}


function show_directory_entries()
{
  connect_db();  // connect to the DB
  $query = "select * from directory_entries where user_id = ".$_SESSION['user_id'];
  $result = safe_query($query);
  if ($result)
  {
    echo "<table border=\"1\">\n";
    echo "<tr>\n";
    echo "\t<td><b>".$_SESSION['lang']['firstname']."</b></td>\n";
    echo "\t<td><b>".$_SESSION['lang']['lastname']."</b></td>\n";
    echo "</tr>\n";

    while ($row = mysql_fetch_array($result, MYSQL_ASSOC))
    {
      echo "<tr>\n";
      echo "\t<td>".$row['name']."</td>\n";
      echo "\t<td>".$row['lastname']."</td>\n";
      echo "\t<td><a href=\"index.php?action=del_directory_entries&entry_id=".$row['entry_id']."\"><img src=\"images/del_entry.png\" border=\"0\" alt=\"".$_SESSION['lang']['delete']."\" title=\"".$_SESSION['lang']['delete']."\"></a></td>\n";
      echo "\t<td><a href=\"index.php?action=mod_directory_entries&entry_id=".$row['entry_id']."\"><img src=\"images/mod_entry.png\" border=\"0\" alt=\"".$_SESSION['lang']['edit']."\" title=\"".$_SESSION['lang']['edit']."\"></a></td>\n";
      echo "\t<td><a href=\"index.php?action=show_directory_entry_numbers&entry_id=".$row['entry_id']."\"><img src=\"images/dir_entry.png\" border=\"0\" alt=\"".$_SESSION['lang']['numbers']."\" title=\"".$_SESSION['lang']['numbers']."\"></a></td>\n";
      echo "</tr>\n";
    }
    echo "</table>\n";
    echo "<br>\n";
    echo "<a href=\"index.php?action=add_directory_entries\"><img src=\"images/add_entry.png\" border=\"0\" >".$_SESSION['lang']['addentry']."</a>\n";
    mysql_free_result($result);
  }
}


function show_number_types()
{
  connect_db();  // connect to the DB
  $query = "select * from directory_types";
  $result = safe_query($query);
  if ($result)
  {
    echo "<div class=\"types\">\n";
    echo $_SESSION['lang']['deltypewarnmsg'];
    echo "</div>\n";
    echo "<br>\n";
    echo "<table border=\"1\">\n";
    echo "<tr>\n";
    echo "\t<td><b>".$_SESSION['lang']['numbertypes']."</b></td>\n";
    echo "</tr>\n";
    while ($row = mysql_fetch_array($result, MYSQL_ASSOC))
    {
      echo "<tr>\n";
      echo "\t<td>".$row['type']."</td>\n";
      echo "\t<td><a href=\"index.php?action=del_number_types&type_id=".$row['type_id']."\"><img src=\"images/del_entry.png\" border=\"0\" alt=\"".$_SESSION['lang']['delete']."\" title=\"".$_SESSION['lang']['delete']."\"></a></td>\n";
      echo "\t<td><a href=\"index.php?action=mod_number_types&type_id=".$row['type_id']."\"><img src=\"images/mod_entry.png\" border=\"0\" alt=\"".$_SESSION['lang']['edit']."\" title=\"".$_SESSION['lang']['edit']."\"></a></td>\n";
      echo "</tr>\n";
    }
    echo "</table>\n";
    echo "<br>\n";
    echo "<a href=\"index.php?action=add_number_types\"><img src=\"images/add_entry.png\" border=\"0\" >".$_SESSION['lang']['addtype']."</a>\n";
    mysql_free_result($result);
  }
}


function del_number_types($type_id)
{
  $query1 = "delete from directory_types where type_id = '$type_id'";
  $query2 = "delete from directory_numbers where type_id = '$type_id'";
  connect_db();  // connect to the DB
  safe_query($query1);
  safe_query($query2);
  show_number_types();
}


function insert_update_types($type_id, $type)
{
  if (empty($type_id))  {
  $query  = "insert into directory_types (type) ";
  $query .= "values ('$type')";
  } else {
  $query  = "update directory_types set ";
  $query .= "type='$type' ";
  $query .= "where type_id='$type_id'";
  }

  connect_db();  // connect to the DB
  safe_query($query);
  show_number_types();
}


function mod_number_types($type_id)
{
  $query = "select * from directory_types where type_id  = '$type_id'";
  connect_db();  // connect to the DB
  $result = safe_query($query);

  if ($result)
  {
    while ($row = mysql_fetch_array($result, MYSQL_ASSOC))
    {
      $type=$row['type'];
    }
  }
  include('add_type.inc.php');
  mysql_free_result($result);
}


function show_directory_entry_numbers($entry_id)
{
  connect_db();  // connect to the DB

  $query  = "select * from directory_types, directory_numbers, directory_entries ";
  $query .= "where directory_types.type_id = directory_numbers.type_id ";
  $query .= "AND directory_entries.entry_id = directory_numbers.entry_id ";
  $query .= "AND directory_numbers.entry_id = '$entry_id' ";
  $query .= "AND directory_entries.user_id = ".$_SESSION['user_id'];
  $result = safe_query($query);

  $query  = "select * from directory_entries ";
  $query .= "where entry_id = '$entry_id' ";
  $query .= "AND user_id = ".$_SESSION['user_id'];
  $name_result = safe_query($query);

  if ($result)
  {
    $name_row = mysql_fetch_array($name_result, MYSQL_ASSOC);
    if (empty($name_row['name'])) {
      show_directory_entries();
      return;
    } else {
      echo "<H3>".$name_row['name']." ".$name_row['lastname']."</H3>";
    }
    echo "<table border=\"1\">\n";
    echo "<tr>\n";
    echo "\t<td><b>".$_SESSION['lang']['numbertype']."</b></td>\n";
    echo "\t<td><b>".$_SESSION['lang']['number']."</b></td>\n";
    echo "</tr>\n";
    while ($row = mysql_fetch_array($result, MYSQL_ASSOC))
    {
      echo "<tr>\n";
      echo "\t<td>".$row['type']."</td>\n";
      echo "\t<td>".$row['number']."</td>\n";
      echo "\t<td><a href=\"index.php?action=del_directory_entry_number&number_id=".$row['number_id']."&entry_id=".$row['entry_id']."\"><img src=\"images/del_entry.png\" border=\"0\" alt=\"".$_SESSION['lang']['delete']."\" title=\"".$_SESSION['lang']['delete']."\"></a></td>\n";
      echo "\t<td><a href=\"index.php?action=mod_directory_entry_numbers&number_id=".$row['number_id']."&entry_id=".$row['entry_id']."\"><img src=\"images/mod_entry.png\" border=\"0\" alt=\"".$_SESSION['lang']['edit']."\" title=\"".$_SESSION['lang']['edit']."\"></a></td>\n";
      echo "</tr>\n";
    }
    echo "</table>\n";
    echo "<br>\n";
    echo "<a href=\"index.php?action=add_directory_entry_numbers&entry_id=$entry_id\"><img src=\"images/add_entry.png\" border=\"0\" >".$_SESSION['lang']['addnumber']."</a>\n";
    mysql_free_result($result);
  }
}


function del_directory_entry_number($number_id, $entry_id)
{
  $query  = "delete from directory_numbers ";
  $query .= "using directory_numbers, directory_entries ";
  $query .= "where directory_numbers.entry_id = directory_entries.entry_id ";
  $query .= "and number_id = '$number_id' ";
  $query .= "and directory_entries.user_id = ".$_SESSION['user_id'];
  connect_db();  // connect to the DB
  safe_query($query);
  show_directory_entry_numbers($entry_id);
}

function mod_directory_entry_numbers($number_id, $entry_id)
{
  $query = "select * from directory_numbers where number_id  = '$number_id'";
  connect_db();  // connect to the DB
  $result = safe_query($query);

  if ($result)
  {
    while ($row = mysql_fetch_array($result, MYSQL_ASSOC))
    {
      $type_id=$row['type_id'];
      $number=$row['number'];
    }
  }
  $query  ="select * from directory_types";
  connect_db();  // connect to the DB
  $result = safe_query($query);

  include('add_number.inc.php');

  mysql_free_result($result);
}

function add_directory_entry_numbers($entry_id)
{
  $query  ="select * from directory_types";
  connect_db();  // connect to the DB
  $result = safe_query($query);

  include('add_number.inc.php');

  mysql_free_result($result);
}


function insert_update_entry_number($number_id, $type_id, $entry_id, $number)
{

  if (empty($number_id))  {
  $query  = "insert into directory_numbers (type_id, entry_id, number) ";
  $query .= "values ('$type_id', '$entry_id', '$number')";
  } else {
  $query  = "update directory_numbers set ";
  $query .= "type_id='$type_id', entry_id='$entry_id', number='$number' ";
  $query .= "where number_id='$number_id'";
  }

  connect_db();  // connect to the DB
  safe_query($query);
  show_directory_entry_numbers($entry_id);
}


function check_login($username, $password)
{
  connect_db();  // connect to the DB
  $query = "select * from directory_user where username = '$username' and password = password('$password')";
  $result = safe_query($query);
  $row = mysql_fetch_array($result, MYSQL_ASSOC);

  if (empty($row)) {
    $login=FALSE;
  }
  else
  {
    $login=$row;
  }
  mysql_free_result($result);
  return $login;
}
?>
